To export a csv from InvoiceNinja:

```
mysql -u root -p --default-character-set=utf8

SELECT
    distinct c.email,
    c.first_name,
    c.last_name
FROM invoices i
LEFT JOIN contacts c
ON i.client_id = c.client_id
WHERE i.is_deleted="0"
AND UNIX_TIMESTAMP(i.invoice_date) > UNIX_TIMESTAMP("2020-08-01")
AND c.email != ""
AND invoice_status_id="6"
AND (c.first_name!="" AND c.first_name!="")
INTO OUTFILE '/var/lib/mysql-files/newsletter.csv'
FIELDS TERMINATED BY ','
ENCLOSED BY '"'
LINES TERMINATED BY '\n';
```

To filter out, emails already present in a csv file:

```
for email in `cat export.csv | awk -F "," '{print $4}' | grep -v EMAIL`; do
  if [ "$email" != "" ]; then
    sed -i "/$email/d" ./newsletter.csv
  fi
done
```