# Instant Backup

Apply following yaml:

```
apiVersion: kubedb.com/v1alpha1
kind: Snapshot
metadata:
  name: snapshot-mongodb
  labels:
    kubedb.com/kind: MongoDB
spec:
  databaseName: rocketchat-mongodb
  storageSecretName: stash-secret
  s3:
    bucket: mybucket
    endpoint: minio.k7.indie.host
    prefix: kubedb
```

# Restore in a new deployment

If you want to restore in another namespace you first need to copy secret and pvc that were created during the snapshot from the namespace where snapshot was done to the new namespace. 

Then apply following yaml:

```
kind: MongoDB
metadata:
  name: rocketchat-mongodb
  namespace: test
spec:
  init:
    snapshotSource:
      name: snapshot-mongodb
  replicaSet:
    name: rs0
  replicas: 1
  storage:
    accessModes:
    - ReadWriteOnce
    resources:
      requests:
        storage: 4Gi
  storageType: Durable
  version: 3.6-v3
```
