# Space management

If you delete entries in Mongo to reclain space, by default Mongo doesn't free disk space.

If you have a cluster, then the procedure is to "rotate" the members of the replica set:

```
k delete po/chat-domain-tld-rs0-2 pvc/mongod-data-chat-domain-tld-rs0-2
```

(make sure to have good backups before)

It could happen that the starting po is not happy, just delete it, and it should work.

# Get the replica set status

```
rc.status()
```

# Clean snapshots older than 2 months in a namespace:

```
kubectl get psmdb-backup -o go-template --template '{{range .items}}{{.metadata.name}} {{.metadata.creationTimestamp}}{{"\n"}}{{end}}' | awk '$2 <= "'$(date -d '2 month ago' -Ins --utc | sed 's/+0000/Z/')'" { print $1 }'  | xargs --no-run-if-empty kubectl delete psmdb-backup
```

Clean snapshots older than 2 months in all namespaces:

```
for NS in `kubectl get psmdb-backup -o go-template --template '{{range .items}}{{.metadata.namespace}}{{"\n"}}{{end}}' -A | uniq`; do
  kubectl -n ${NS} get psmdb-backup -o go-template --template '{{range .items}}{{.metadata.name}} {{.metadata.creationTimestamp}}{{"\n"}}{{end}}' | awk '$2 <= "'$(date -d '2 month ago' -Ins --utc | sed 's/+0000/Z/')'" { print $1 }'  | xargs --no-run-if-empty kubectl -n {NS} delete psmdb-backup;
done
```
