Procedure to proxy from one cluster to another to avoind down time when moving workload between clusters and updating dns.

Deploy the app on the new cluster.

Create an svc on the first cluster:

```
apiVersion: v1
kind: Service
metadata:
  name: acme-libre-sh
  namespace: libre-sh
spec:
  type: ExternalName
  externalName: cluster.beta.liiib.re
```

Update your ingress to add the proxy for port 80, to get the cert made on the new cluster:

```
apiVersion: extensions/v1beta1
kind: Ingress
metadata:
  name: libre-sh
  namespace: libre-sh
spec:
  rules:
  - host: k8s.libre.sh
    http:
      paths:
      - backend:
          serviceName: acme-libre-sh
          servicePort: 80
        path: /.well-known/acme-challenge
      - backend:
          serviceName: libresh-web
          servicePort: http
        path: /
  tls:
  - hosts:
    - k8s.libre.sh
    secretName: k8s-libresh-tls
```

Once the cert is created on the second cluster, proxy all the traffic with an https backend:

```
apiVersion: extensions/v1beta1
kind: Ingress
metadata:
  name: libre-sh
  namespace: libre-sh
  annotations:
    nginx.ingress.kubernetes.io/backend-protocol: HTTPS
spec:
  rules:
  - host: k8s.libre.sh
    http:
      paths:
      - backend:
          serviceName: acme-libre-sh
          servicePort: 443
        path: /
  tls:
  - hosts:
    - k8s.libre.sh
    secretName: k8s-libresh-tls
```
