If you want to delete users that didn't login in the last 4 months:


```
    select uid, e.configvalue as email
    from oc_users u
    INNER JOIN (
        select userid, configvalue  from oc_preferences where configkey = "lastLogin") ll
    ON u.uid = ll.userid
    left JOIN (
        select userid, configvalue  from oc_preferences where configkey = "email") e
    ON u.uid = e.userid
    WHERE ll.configvalue < UNIX_TIMESTAMP(SUBDATE(CURDATE(), INTERVAL 4 MONTH))
    INTO OUTFILE '/var/lib/mysql/to-delete-users.csv'
    FIELDS TERMINATED BY ','
    ENCLOSED BY '"'
    LINES TERMINATED BY '\n';
```

Get the file and copy it to your Nextcloud folder.

```
cat data/to-delete-users.csv | cut -d, -f1 > /tmp/users
```

And then loop though it to delete them
```
cat /tmp/users | xargs -L 1 php occ user:delete --
```