---
title: Misc
weight: 2
---

## strenghts of kubernetes

Industry is moving to kubernetes, so we benefit from the best engineers developing the most amazing platform. We are living the same revolution as when industry moved from hardware to VM. Now we are moving from VMs to containers.

The platform is highly available by design and also highly scalable. It can also run on a single host if you want.

## the green argument

Another argument for using an orchestration platform like kubernetes is resource consumption.
Once you run on a datacenter with green energy and use second hand hardware, what can you do to move further? You have to use more each cpu.

Compared to classic virtualisation, you can put a lot more services with kubernetes. A VM gets a cpu and memory allocated whereas containers can grow dynamically (you can also reserve resources for critical workload).

And because of this reason, kubernetes is greener than classic virtualisation.

## complexity

Kubernetes is made to [manage thousands of VMs and hundred of thousands of pods](https://docs.openshift.com/container-platform/4.2/scalability_and_performance/planning-your-environment-according-to-object-limits.html). At this scale, the underlying platform has to be somewhat complex.

But once you understand kubernetes, you realize that it is actually beautifully simple inside.

Everythings relies on the registration discovery pattern. Here is how to schedule a pod on a node for instance:

 - from cli, you execute `kubectl run --image=nginx nginx-app` to start an nginx pod
 - your cli goes to the API to make this POST request
 - the API registers in the central database that a pod has to run with this image
 - the scheduler discovers that a pod has to run and doesn't run yet
 - the scheduler finds an appropirate node to run the pod and registers it in the database
 - the node discovers that it has to run a pod and doesn't run yet
 - the node starts the pod and write back the status of the pod in the database
 - from your cli, you get the status of the pod

Go to [Julia Evan's blog](https://jvns.ca/categories/kubernetes/) to discover more, it is amazing content ;)

As you see, it is pretty simple, and that's why it is reliable, even at the google scale.

In term of network, it is also complex, as you have to span an overlay network between different host and give an IP address to each pod. It is a complex problem to solve, but some smarter people already solved it, so we can rely on such solutions.

## security

Security depends a lot on your threat modeling.

It is a fact that containers are less secured than VMs. But then it depends on what kind of isolation you need.

If you want to run free software for people, we think that containers are more than secure enough. We know which code runs on our hardware, and we don't think we need VM level isolation. And if there is a bug in linux containers, we patch.

## single host

Kubernetes could also run on a single host. Some people might think it would be overkill to run so many processes, for just running one applciation, but why not?

There is an effort called [k3s](https://github.com/rancher/k3s), and it is said to run on 150MB of RAM. Now imagine that you can shutdown the control plane, and run it with a cron once a night to update. It could make a good candidate to evolve https://lollipopcloud.solutions/ or even yunohost.

## declarative API

The kubernetes API is declarative. It means you declare how the world should look like.
For instance, you can say, "My desire is to have a redis instance with these parameters".

This is diffrent than a imperative API. For our redis instance, it would mean to say instead: "Please create a redis instance, then create a service to expose it, and finally, create a secret and configure redis with that."

In the declarative case, there is no need to detail the flow that modifies the different states.

This is what allows us to build higher level objects, like Nextcloud instances, and hide all the logic in our operators, and make the end user desire happen.
