---
title: The cloud API
weight: 1
---

The main argument is favor of kubernetes is probably the fact that this is becoming The cloud API.

## A bit of history

In 2006, Google contributed the code to the linux kernel to make linux containers possible. Then heroku started their PaaS business. And RedHat started their Open Source PaaS - OpenShift - to stay relevant in the business.
Fast forward to 2015, RedHat joins Google to found the Cloud Native Computing Foundation and work together on Kubernetes, under the umbrella of the Linux FOundation.

Between the lines, you can read that the intent behind kubernetes is to become, at least, a really good cloud API.

## Not the first abstraction to cloud APIs

It is not the first time that open source project try to be an abstraction to popular cloud vendors. There are a few like ansible, or terraform. But they failed, because at the end of the day, you need to take care of the little vairations of each provider.

## what is a cloud API

But what is a cloud API anyway you can ask. It is a way to provision:

 - compute (CPU)
 - memory
 - disk
 - network (L4 and L7)

With an API, in a self service fashion.

The difference between terraform and kubernetes is the way this abstraction is made. Take disk for instance.
In kubernetes, they are called Persistent Volumes (PV), and when you work with kubernetes, you manipulate thes objects.
Then, depending on your cloud provider (Google Cloud, AWS, ..) or even behing in your own datacenter, you can have a different volume provider taking care of making your desire to have a Volume happen.
Even better, you could have different volume providers on the same cluster, all nicely abstracted by this object.

And kubernetes provides this nice abstraction for everyhting you need to run hosted free software, in a beautiful way.

## Google compete against AWS

Another thing to keep in mind is that Google Cloud is a direct competitor of AWS.
At the time of open sourcing Kubernetes, the docker orchestration war already started, and the world was desparetly in need of a nice orchestrator. Google had a bit of experience in this field. And They saw a nice opportunity to compete against AWS.

Imagine, if the world adopts Kubernetes, which is what is happening. Then the barrier to exit AWS just became a lot cheaper.
It is not a secret that AWS was one of the last big tech compagny to join the CNCF. And it is probably because, kubernetes is a threat to their business model, to some extent.

## The last package manager?

There is this nice read from Helm about [what is a package manager](https://github.com/helm/community/blob/master/helm-v3/009-package_manager.md). And if you think like [CoreOS that the future of the datacenter, or the cloud, is to build an Operating System](https://coreos.com/blog/cluster-osi-model.html). (Funnily this is also Mesos - another container orchestrator - Marketting [DataCenter OS](https://dcos.io/)).

Whether you agree with what was said before, it has at least the merit to ask questions. How do we run cluster at scale? How do we deploy in a high availability manner? How do we backup and restore? And more importantly, how do we share these recipes, with a free software license attached.

WordPress, the code is free software. Great you can install it on your php provider. But then the exercise of installing and updating is left as an exercise to the reader.

One component of Kubernetes is definitely to address that. To some extent, kubernetes, and/or tools around are becoming the standard package manager. Some popular proprietary vendors like SAP are now shipping their software as a kuberntes package. They tell their customers, just provide us a cluster, we take care of the rest. Even [OpenStack](https://github.com/openstack/openstack-helm) is shipped as a kubernetes package!

For all these reasons, kubernetes is becoming The cloud API, and the OS of your infrastructure, and the package manager to deploy your FLOSS.