package sh.libre.scim.core;

import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;

/**
 * In charge of dealing with SCIM exceptions by ignoring, logging or rollback transaction according to :
 * - The context in which it occurs (sync, user creation...)
 * - The related SCIM endpoint and its configuration
 * - The thrown exception itself
 */
public class ScimExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(ScimExceptionHandler.class);

    private final KeycloakSession session;

    public ScimExceptionHandler(KeycloakSession session) {
        this.session = session;
    }

    /**
     * Handles the given exception by loggin and/or rollback transaction.
     *
     * @param scimProviderConfiguration the configuration of the endpoint for which the propagation exception occured
     * @param e                         the occuring exception
     */
    public void handleException(ScrimProviderConfiguration scimProviderConfiguration, ScimPropagationException e) {
        LOGGER.error("[SCIM] Error while propagating to SCIM endpoint %s", scimProviderConfiguration.getId(), e);
        // TODO Exception Handling : rollback only for critical operations, if configuration says so
        // session.getTransactionManager().rollback();
    }

    public void handleInvalidEndpointConfiguration(ComponentModel scimEndpointConfigurationRaw, Exception e) {
        LOGGER.error("[SCIM] Invalid Endpoint configuration " + scimEndpointConfigurationRaw.getId(), e);
        // TODO Exception Handling is it ok to ignore an invalid Scim endpoint Configuration ?
        // IF not, we should propagate the exception here
    }
}
