"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScimApp = void 0;
const api_1 = require("@rocket.chat/apps-engine/definition/api");
const App_1 = require("@rocket.chat/apps-engine/definition/App");
const GroupEndpoint_1 = require("./src/endpoints/GroupEndpoint");
const GroupsEndpoint_1 = require("./src/endpoints/GroupsEndpoint");
const UserEndpoint_1 = require("./src/endpoints/UserEndpoint");
const UsersEndpoint_1 = require("./src/endpoints/UsersEndpoint");
class ScimApp extends App_1.App {
    constructor(info, logger, accessors) {
        super(info, logger, accessors);
    }
    async extendConfiguration(configuration) {
        configuration.api.provideApi({
            visibility: api_1.ApiVisibility.PUBLIC,
            security: api_1.ApiSecurity.UNSECURE,
            endpoints: [
                new UsersEndpoint_1.UsersEndpoint(this),
                new UserEndpoint_1.UserEndpoint(this),
                new GroupsEndpoint_1.GroupsEndpoint(this),
                new GroupEndpoint_1.GroupEndpoint(this),
            ],
        });
    }
}
exports.ScimApp = ScimApp;
