"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Context = void 0;
const buffer_1 = require("buffer");
const EmptyRequestError_1 = require("../errors/EmptyRequestError");
const UnauthorizedError_1 = require("../errors/UnauthorizedError");
const RcSdk_1 = require("../rc-sdk/RcSdk");
const Store_1 = require("../store/Store");
class Context {
    constructor(request, endpoint, read, modify, http, persis, log) {
        this.request = request;
        this.endpoint = endpoint;
        this.read = read;
        this.modify = modify;
        this.http = http;
        this.persis = persis;
        this.log = log;
        this.store = new Store_1.Store(read, persis);
        try {
            const value = this.request.headers.authorization.replace("Basic ", "");
            const decodedValue = buffer_1.Buffer.from(value, "base64").toString("utf-8");
            const [username, password] = decodedValue.split(":");
            this.rc = new RcSdk_1.RcSdk(username, password, http, log);
        }
        catch (_a) {
            throw new UnauthorizedError_1.UnauthorizedError();
        }
    }
    id() {
        return this.request.params.id;
    }
    content() {
        if (!this.request.content ||
            Object.keys(this.request.content).length === 0) {
            throw new EmptyRequestError_1.EmptyRequestError();
        }
        return this.request.content;
    }
}
exports.Context = Context;
