"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupEndpoint = void 0;
const accessors_1 = require("@rocket.chat/apps-engine/definition/accessors");
const Group_1 = require("../scim/Group");
const ScimEndpoint_1 = require("./ScimEndpoint");
class GroupEndpoint extends ScimEndpoint_1.ScimEndpoint {
    constructor() {
        super(...arguments);
        this.path = "Groups/:id";
    }
    async _get(ctx) {
        const getTeamInfo = async () => {
            const teamRaw = await ctx.rc.team.info(ctx.id());
            this.handleError(teamRaw);
            return teamRaw.teamInfo;
        };
        const getTeamMembers = async () => {
            const membersRaw = await ctx.rc.team.members(ctx.id());
            this.handleError(membersRaw);
            return membersRaw.members;
        };
        const teamArgs = await Promise.all([getTeamInfo(), getTeamMembers()]);
        const group = Group_1.SCIMGroup.fromRC(...teamArgs);
        const meta = await ctx.store.getGroup(group.id);
        if (meta) {
            group.externalId = meta.externalId;
        }
        return this.success(group);
    }
    async _put(ctx) {
        const u = Group_1.SCIMGroup.fromPlain(ctx.content());
        const o = await ctx.rc.team.update({
            teamId: ctx.id(),
            data: {
                name: u.displayName,
            },
        });
        this.handleError(o);
        await ctx.store.saveGroup(ctx.id(), { externalId: u.externalId });
        const membersRaw = await ctx.rc.team.members(ctx.id());
        this.handleError(membersRaw);
        const targetIds = new Set(Group_1.SCIMGroup.fromPlain(ctx.content()).members.map((x) => x.value));
        targetIds.add(ctx.rc.userId);
        const currentIds = new Set(membersRaw.members.map((x) => x.user._id));
        const removeMember = async (userId) => {
            const removeMembersRaw = await ctx.rc.team.removeMember({
                userId,
                teamId: ctx.id(),
            });
            this.handleError(removeMembersRaw);
        };
        const addMembers = async (userIds) => {
            const addMembersRaw = await ctx.rc.team.addMembers({
                teamId: ctx.id(),
                members: userIds.map((userId) => ({
                    userId,
                    roles: ["member"],
                })),
            });
            this.handleError(addMembersRaw);
        };
        const promises = [];
        for (const currentId of currentIds) {
            if (!targetIds.has(currentId)) {
                promises.push(removeMember(currentId));
            }
        }
        const addMemberIds = [];
        for (const targetId of targetIds) {
            if (!currentIds.has(targetId)) {
                addMemberIds.push(targetId);
            }
        }
        if (addMemberIds.length > 0) {
            promises.push(addMembers(addMemberIds));
        }
        await Promise.all(promises);
        return this._get(ctx);
    }
    async _delete(ctx) {
        const o = await ctx.rc.team.delete({ teamId: ctx.id() });
        this.handleError(o);
        await ctx.store.deleteGroup(ctx.id());
        return this.response({
            status: accessors_1.HttpStatusCode.NO_CONTENT,
        });
    }
}
exports.GroupEndpoint = GroupEndpoint;
