"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupsEndpoint = void 0;
const accessors_1 = require("@rocket.chat/apps-engine/definition/accessors");
const Group_1 = require("../scim/Group");
const ListResponse_1 = require("../scim/ListResponse");
const ScimEndpoint_1 = require("./ScimEndpoint");
class GroupsEndpoint extends ScimEndpoint_1.ScimEndpoint {
    constructor() {
        super(...arguments);
        this.path = "Groups";
    }
    async _get(ctx) {
        const teamsRaw = await ctx.rc.team.listAll();
        this.handleError(teamsRaw);
        const groups = teamsRaw.teams.map(async (team) => {
            const membersRaw = await ctx.rc.team.members(team._id);
            this.handleError(membersRaw);
            const group = Group_1.SCIMGroup.fromRC(team, membersRaw.members);
            const meta = await ctx.store.getGroup(group.id);
            if (meta) {
                group.externalId = meta.externalId;
            }
            return group;
        });
        const list = new ListResponse_1.SCIMListResponse();
        list.Resources = await Promise.all(groups);
        list.totalResults = teamsRaw.total;
        return this.success(list);
    }
    async _post(ctx) {
        const u = Group_1.SCIMGroup.fromPlain(ctx.content());
        const o = await ctx.rc.team.create({
            name: u.displayName,
            type: 1,
            members: u.members.map((x) => x.value),
        });
        this.handleError(o);
        const m = await ctx.rc.team.members(o.team._id);
        const group = Group_1.SCIMGroup.fromRC(o.team, m.members);
        group.externalId = u.externalId;
        await ctx.store.saveGroup(group.id, { externalId: group.externalId });
        return this.response({
            status: accessors_1.HttpStatusCode.CREATED,
            content: group,
        });
    }
}
exports.GroupsEndpoint = GroupsEndpoint;
