"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersEndpoint = void 0;
const accessors_1 = require("@rocket.chat/apps-engine/definition/accessors");
const crypto = require("crypto");
const ListResponse_1 = require("../scim/ListResponse");
const User_1 = require("../scim/User");
const user_1 = require("./common/user");
const ScimEndpoint_1 = require("./ScimEndpoint");
class UsersEndpoint extends ScimEndpoint_1.ScimEndpoint {
    constructor() {
        super(...arguments);
        this.path = "Users";
    }
    async _get(ctx) {
        const o = await ctx.rc.user.list();
        this.handleError(o);
        const list = new ListResponse_1.SCIMListResponse();
        list.Resources = await Promise.all(o.users.map(User_1.SCIMUser.fromRC).map(async (x) => {
            const meta = await ctx.store.getUser(x.id);
            if (meta) {
                x.externalId = meta.externalId;
            }
            return x;
        }));
        list.totalResults = o.total;
        return this.success(list);
    }
    async _post(ctx) {
        const u = User_1.SCIMUser.fromPlain(ctx.content());
        const roles = await (0, user_1.findOrCreateRole)(ctx, u);
        const o = await ctx.rc.user.create({
            email: u.getEmail(),
            name: u.displayName || u.userName,
            username: u.userName,
            password: crypto.randomBytes(64).toString("base64").slice(0, 64),
            roles,
            verified: true,
            customFields: {
                scimExternalId: u.externalId,
            },
        });
        this.handleError(o);
        const user = User_1.SCIMUser.fromRC(o.user);
        user.externalId = u.externalId;
        await ctx.store.saveUser(user.id, { externalId: user.externalId });
        return this.response({
            status: accessors_1.HttpStatusCode.CREATED,
            content: user,
        });
    }
}
exports.UsersEndpoint = UsersEndpoint;
