"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleRcError = void 0;
const ConflictError_1 = require("../../errors/ConflictError");
const UnauthorizedError_1 = require("../../errors/UnauthorizedError");
function handleRcError(o) {
    var _a, _b;
    if (!o.success) {
        if (o.status === "error") {
            if (o.message === "You must be logged in to do this.") {
                throw new UnauthorizedError_1.UnauthorizedError(o.error);
            }
        }
        if ((_a = o.error) === null || _a === void 0 ? void 0 : _a.includes("already in use")) {
            throw new ConflictError_1.ConflictError(o.error.includes("@") ? "email" : "username");
        }
        if ((_b = o.error) === null || _b === void 0 ? void 0 : _b.includes("not found")) {
        }
        throw new Error(o.error);
    }
}
exports.handleRcError = handleRcError;
