"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findOrCreateRole = void 0;
const endpoint_1 = require("./endpoint");
async function findOrCreateRole(ctx, user) {
    const listResp = await ctx.rc.role.list();
    (0, endpoint_1.handleRcError)(listResp);
    const rcRoles = listResp.roles;
    const roles = await Promise.all(user.roles.map(async ({ value }) => {
        let rcRole = rcRoles.find((x) => x.name === value);
        if (!rcRole) {
            const r = await ctx.rc.role.create({ name: value });
            (0, endpoint_1.handleRcError)(r);
            rcRoles.push(r.role);
            rcRole = r.role;
        }
        return rcRole._id;
    }));
    return roles;
}
exports.findOrCreateRole = findOrCreateRole;
