"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConflictError = void 0;
const accessors_1 = require("@rocket.chat/apps-engine/definition/accessors");
const Error_1 = require("../scim/Error");
const BaseError_1 = require("./BaseError");
class ConflictError extends BaseError_1.BaseError {
    constructor(type) {
        super();
        this.type = "";
        this.type = type;
    }
    get message() {
        return `This ${this.type} already exists`;
    }
    toSCIMError() {
        return new Error_1.SCIMError()
            .setStatus(accessors_1.HttpStatusCode.CONFLICT)
            .setScimType(Error_1.SCIMErrorType.INVALID_VALUE)
            .setDetail(this.message);
    }
}
exports.ConflictError = ConflictError;
