"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmptyRequestError = void 0;
const accessors_1 = require("@rocket.chat/apps-engine/definition/accessors");
const Error_1 = require("../scim/Error");
const BaseError_1 = require("./BaseError");
class EmptyRequestError extends BaseError_1.BaseError {
    constructor() {
        super(...arguments);
        this.message = "Request body is empty or content type is unsupported";
    }
    toSCIMError() {
        return new Error_1.SCIMError()
            .setStatus(accessors_1.HttpStatusCode.BAD_REQUEST)
            .setScimType(Error_1.SCIMErrorType.INVALID_VALUE)
            .setDetail(this.message);
    }
}
exports.EmptyRequestError = EmptyRequestError;
