"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EmptyResponseError = void 0;
const accessors_1 = require("@rocket.chat/apps-engine/definition/accessors");
const Error_1 = require("../scim/Error");
const BaseError_1 = require("./BaseError");
class EmptyResponseError extends BaseError_1.BaseError {
    constructor() {
        super(...arguments);
        this.message = "Rocket.Chat API returned an empty response";
    }
    toSCIMError() {
        return new Error_1.SCIMError()
            .setStatus(accessors_1.HttpStatusCode.INTERNAL_SERVER_ERROR)
            .setScimType(Error_1.SCIMErrorType.INVALID_VALUE)
            .setDetail(this.message);
    }
}
exports.EmptyResponseError = EmptyResponseError;
