"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnauthorizedError = void 0;
const accessors_1 = require("@rocket.chat/apps-engine/definition/accessors");
const Error_1 = require("../scim/Error");
const BaseError_1 = require("./BaseError");
class UnauthorizedError extends BaseError_1.BaseError {
    constructor() {
        super(...arguments);
        this.message = "The username or password is missing or incorrect.";
    }
    toSCIMError() {
        return new Error_1.SCIMError()
            .setStatus(accessors_1.HttpStatusCode.UNAUTHORIZED)
            .setScimType(Error_1.SCIMErrorType.INVALID_SYNTAX)
            .setDetail(this.message);
    }
}
exports.UnauthorizedError = UnauthorizedError;
