"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RcSdkTeam = void 0;
class RcSdkTeam {
    constructor(sdk) {
        this.sdk = sdk;
    }
    listAll() {
        return this.sdk.get(`teams.listAll?count=0`);
    }
    members(teamId) {
        return this.sdk.get(`teams.members?teamId=${teamId}&count=0`);
    }
    info(teamId) {
        return this.sdk.get(`teams.info?teamId=${teamId}`);
    }
    delete(body) {
        return this.sdk.post(`teams.delete`, body);
    }
    create(body) {
        return this.sdk.post(`teams.create`, body);
    }
    update(body) {
        return this.sdk.post(`teams.update`, body);
    }
    removeMember(body) {
        return this.sdk.post(`teams.removeMember`, body);
    }
    addMembers(body) {
        return this.sdk.post(`teams.addMembers`, body);
    }
}
exports.RcSdkTeam = RcSdkTeam;
