"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RcSdkUser = void 0;
class RcSdkUser {
    constructor(sdk) {
        this.sdk = sdk;
    }
    list() {
        return this.sdk.get(`users.list?query={"type":"user"}&fields={"type":1,"createdAt":1}&count=0`);
    }
    info(userId) {
        return this.sdk.get(`users.info?userId=${userId}`);
    }
    update(body) {
        return this.sdk.post(`users.update`, body);
    }
    delete(body) {
        return this.sdk.post(`users.delete`, body);
    }
    create(body) {
        return this.sdk.post(`users.create`, body);
    }
}
exports.RcSdkUser = RcSdkUser;
