"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SCIMError = exports.SCIMErrorDetail = exports.SCIMErrorType = void 0;
var SCIMErrorType;
(function (SCIMErrorType) {
    SCIMErrorType["INVALID_FILTER"] = "invalidFilter";
    SCIMErrorType["TOO_MANY"] = "tooMany";
    SCIMErrorType["UNIQUENESS"] = "uniqueness";
    SCIMErrorType["MUTABILITY"] = "mutability";
    SCIMErrorType["INVALID_SYNTAX"] = "invalidSyntax";
    SCIMErrorType["INVALID_PATH"] = "invalidPath";
    SCIMErrorType["NO_TARGET"] = "noTarget";
    SCIMErrorType["INVALID_VALUE"] = "invalidValue";
    SCIMErrorType["INVALID_VERS"] = "invalidVers";
    SCIMErrorType["SENSITIVE"] = "sensitive";
})(SCIMErrorType = exports.SCIMErrorType || (exports.SCIMErrorType = {}));
var SCIMErrorDetail;
(function (SCIMErrorDetail) {
    SCIMErrorDetail["TEMPORARY_REDIRECT"] = "The client is directed to repeat the same HTTP request at the location identified.";
    SCIMErrorDetail["PERMANENT_REDIRECT"] = "The client is directed to repeat the same HTTP request at the location identified.";
    SCIMErrorDetail["BAD_REQUEST"] = "Request is unparsable, syntactically incorrect, or violates schema.";
    SCIMErrorDetail["UNAUTHORIZED"] = "Authorization failure. The authorization header is invalid or missing.";
    SCIMErrorDetail["FORBIDDEN"] = "Operation is not permitted based on the supplied authorization.";
    SCIMErrorDetail["NOT_FOUND"] = "Specified resource or endpoint does not exist.";
    SCIMErrorDetail["CONFLICT"] = "The specified version number does not match the resource's latest version number, or a service provider refused to create a new, duplicate resource.";
    SCIMErrorDetail["PRECONDITION_FAILED"] = "Failed to update.  Resource has changed on the server.";
    SCIMErrorDetail["PAYLOAD_TOO_LARGE"] = "{\"maxOperations\": 1000,\"maxPayloadSize\": 1048576}";
    SCIMErrorDetail["INTERNAL_SERVER_ERROR"] = "An internal error.";
    SCIMErrorDetail["NOT_IMPLEMENTED"] = "Service provider does not support the request operation.";
})(SCIMErrorDetail = exports.SCIMErrorDetail || (exports.SCIMErrorDetail = {}));
class SCIMError {
    setScimType(scimType) {
        this.scimType = scimType;
        return this;
    }
    setStatus(status) {
        this.status = `${status}`;
        return this;
    }
    setDetail(detail) {
        this.detail = detail;
        return this;
    }
}
exports.SCIMError = SCIMError;
