"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SCIMGroup = void 0;
const Meta_1 = require("./Meta");
class SCIMGroup {
    constructor() {
        this.schemas = ["urn:ietf:params:scim:schemas:core:2.0:Group"];
        this.members = [];
        this.meta = new Meta_1.SCIMMeta("Group", () => this.id);
    }
    static fromPlain(plain) {
        const group = new SCIMGroup();
        group.id = plain.id;
        group.externalId = plain.externalId;
        group.displayName = plain.displayName;
        group.members = plain.members || [];
        return group;
    }
    static fromRC(rc, members) {
        const group = new SCIMGroup();
        group.id = rc._id;
        group.externalId = rc._id;
        group.displayName = rc.name;
        group.meta.created = new Date(rc.createdAt);
        group.meta.lastModified = new Date(rc._updatedAt || rc.createdAt);
        group.members = members.map((member) => ({
            value: member.user._id,
            $ref: `/Users/${member.user._id}`,
            display: member.user.name,
        }));
        return group;
    }
}
exports.SCIMGroup = SCIMGroup;
