"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SCIMMeta = void 0;
class SCIMMeta {
    constructor(resourceType, id) {
        this.id = id;
        this.resourceType = resourceType;
        const now = Date.now();
        this.created = new Date(now);
        this.lastModified = new Date(now);
    }
    get location() {
        return `/${this.resourceType}s/${this.id()}`;
    }
    toJSON() {
        return Object.assign(Object.assign({}, this), { location: this.location });
    }
}
exports.SCIMMeta = SCIMMeta;
