"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SCIMUser = void 0;
const Meta_1 = require("./Meta");
class SCIMUser {
    constructor() {
        this.schemas = ["urn:ietf:params:scim:schemas:core:2.0:User"];
        this.name = {};
        this.emails = [];
        this.roles = [{ value: "user" }];
        this.meta = new Meta_1.SCIMMeta("User", () => this.id);
    }
    static fromPlain(plain) {
        const user = new SCIMUser();
        user.id = plain.id;
        user.externalId = plain.externalId;
        user.userName = plain.userName;
        user.displayName = plain.displayName;
        user.active = plain.active;
        user.name = plain.name;
        user.emails = plain.emails;
        user.setRoles(plain.roles);
        return user;
    }
    static fromRC(rc) {
        const user = new SCIMUser();
        user.id = rc._id;
        if (rc.emails && rc.emails.length > 0) {
            const email = rc.emails[0];
            user.emails = [{ primary: true, value: email.address }];
        }
        user.displayName = rc.name;
        user.userName = rc.username;
        user.meta.created = new Date(rc.createdAt);
        user.meta.lastModified = new Date(rc.createdAt);
        if (rc.active !== undefined) {
            user.active = rc.active;
        }
        return user;
    }
    getEmail() {
        if (this.emails.length > 0) {
            return this.emails[0].value;
        }
        return "";
    }
    setRoles(roles) {
        this.roles = roles;
        if (!roles.find((x) => x.value === "user")) {
            this.roles.push({ value: "user" });
        }
    }
}
exports.SCIMUser = SCIMUser;
