"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Store = void 0;
const metadata_1 = require("@rocket.chat/apps-engine/definition/metadata");
class Store {
    constructor(read, persis) {
        this.read = read;
        this.persis = persis;
    }
    deleteUser(id) {
        return this.persis.removeByAssociation(new metadata_1.RocketChatAssociationRecord(metadata_1.RocketChatAssociationModel.USER, id));
    }
    saveUser(id, meta) {
        return this.persis.updateByAssociation(new metadata_1.RocketChatAssociationRecord(metadata_1.RocketChatAssociationModel.USER, id), meta, true);
    }
    async getUser(id) {
        const list = await this.read
            .getPersistenceReader()
            .readByAssociation(new metadata_1.RocketChatAssociationRecord(metadata_1.RocketChatAssociationModel.USER, id));
        if (list.length > 0) {
            return list[0];
        }
        return;
    }
    deleteGroup(id) {
        return this.persis.removeByAssociation(new metadata_1.RocketChatAssociationRecord(metadata_1.RocketChatAssociationModel.ROOM, id));
    }
    saveGroup(id, meta) {
        return this.persis.updateByAssociation(new metadata_1.RocketChatAssociationRecord(metadata_1.RocketChatAssociationModel.ROOM, id), meta, true);
    }
    async getGroup(id) {
        const list = await this.read
            .getPersistenceReader()
            .readByAssociation(new metadata_1.RocketChatAssociationRecord(metadata_1.RocketChatAssociationModel.ROOM, id));
        if (list.length > 0) {
            return list[0];
        }
        return;
    }
}
exports.Store = Store;
