<?php

namespace OCA\SCIMServiceProvider\AppInfo;

use OCA\SCIMServiceProvider\Middleware\AuthMiddleware;
use OCA\SCIMServiceProvider\Middleware\ContentTypeMiddleware;
use OCA\SCIMServiceProvider\Middleware\ErrorMiddleware;
use OCP\AppFramework\App;
use OCP\AppFramework\Bootstrap\IBootContext;
use OCP\AppFramework\Bootstrap\IBootstrap;
use OCP\AppFramework\Bootstrap\IRegistrationContext;

/**
 * The main entry point of the entire application
 */
class Application extends App implements IBootstrap {
	public const APP_ID = 'scimserviceprovider';
	public const APP_NAME = 'SCIM';

	public function __construct() {
		parent::__construct(self::APP_ID);
	}

	/**
	 * This method is used for registering services, needed as dependencies via dependency injection (DI)
	 *
	 * Note: "service" here means simply a class that is needed as a dependency somewhere
	 * and needs to be injected as such via a DI container (as per PSR-11)
	 */
	public function register(IRegistrationContext $context): void {
		require_once(__DIR__  . '/../../vendor/autoload.php');
		$context->registerMiddleware(ErrorMiddleware::class);
		$context->registerMiddleware(AuthMiddleware::class);
		$context->registerMiddleware(ContentTypeMiddleware::class);
	}

	/**
	 * This method is called for starting (i.e., booting) the application
	 *
	 * Note: here the method body is empty, since we don't need to do any extra work in it
	 */
	public function boot(IBootContext $context): void {
	}
}
