<?php

declare(strict_types=1);

namespace OCA\SCIMServiceProvider\Middleware;

use Exception;
use OCA\SCIMServiceProvider\Responses\SCIMErrorResponse;
use OCP\AppFramework\Controller;
use OCP\AppFramework\Middleware;

class ErrorMiddleware extends Middleware {
	public function afterException(Controller $controller, string $methodName, Exception $exception) {
		return new SCIMErrorResponse($exception);
	}
}
