<?php

namespace OCA\SCIMServiceProvider\Util;

use OCP\IRequest;

class Util {
	public const SCIM_APP_URL_PATH = "index.php/apps/scimserviceprovider";

	public static function getBaseUrl(IRequest $request) : string {
		return $request->getServerProtocol() . "://" . $request->getServerHost() . "/" . Util::SCIM_APP_URL_PATH;
	}

	public static function parsePagination(array $params): array {
		if (isset($params["startIndex"])) {
			$startIndex = intval($params["startIndex"]);
			if ($startIndex < 1) {
				$startIndex = 1;
			}
			$params["startIndex"] = $startIndex;
		} else {
			$params["startIndex"] = 1;
		}
		if (isset($params["count"])) {
			$count = intval($params["count"]);
			if ($count < 0) {
				$count = 0;
			}
			$params["count"] = $count;
		}
		return $params;
	}
}
