# SCIM Service Provider

This app allows to provision users and groups in Nextcloud from a scim client. It is based on [audriga/scim-server-php](https://github.com/audriga/scim-server-php) SCIM library.

You can see the [video](https://hot-objects.liiib.re/meet-liiib-re-recordings/pair_2022-05-02-15-40-37.mp4) that shows how it works.

## Installation

Like any other app, it's available on Nextcloud's [app store](https://apps.nextcloud.com/apps/scimserviceprovider).

## Authentication

Basic and bearer authentication are supported. For now, only admin users are authorized to access SCIM APIs.

### Basic authentication

You just have to generate an app password in `/settings/user/security`.

### Bearer authentication

It requires a JWT secret, to be enabled.
```shell
php occ config:app:set scimserviceprovider jwt-secret --value="CHANGE_ME"
```

Then you should generate a JWT signed with this secret and with `sub` in the payload referring to an existing username. ([Handy CLI tool](https://github.com/mike-engel/jwt-cli))
```shell
jwt encode --secret "CHANGE_ME" '{"sub":"admin"}'
```

## Usage

```
$ curl http://<path-to-nextcloud>/index.php/apps/scimserviceprovider/<Resource> -H 'Authorization: <Auth>' -H 'Content-Type: application/scim+json'
```

Where `<Resource>` designates a SCIM resource, such as `Users` or `Groups`.

### With Keycloak

You can use with the [SCIM plugin we developped for keycloak](https://lab.libreho.st/libre.sh/scim/keycloak-scim).

### With AzureAD

You can provision users from AzureAD to Nextcloud with this app. For this, you need to setup [Bearer authentication](#bearer-authentication).

## Running tests

Broken.

## Todo

 - [ ] Meta -> ([can't implement yet](https://github.com/nextcloud/server/issues/22640))
    - createdAt
    - lastModified
 - [ ] ExternalID
    - [ ] Groups - [waiting for feedback](https://help.nextcloud.com/t/add-metadata-to-groups/139271)
 - [ ] json exceptions
 - [x] group member removal
 - [x] pagination
 - [ ] CI/CD
   - [ ] Lint cs:check
   - [ ] test psalm
   - [ ] test insomnia
   - [x] publish app on app store
 - [x] Allow for simultaneous usage of basic auth and bearer token auth (see **Authentication TODOs / Open issues**)

## Disclaimer
This app relies on the fixes, being introduced to Nextcloud in [PR #34172](https://github.com/nextcloud/server/pull/34172), since Nextcloud can't properly handle the `Content-Type` header value for SCIM (`application/scim+json`) otherwise. In the meantime until this PR is merged, SCIM clients interacting with this app might need to resort to using the standard value of `application/json` instead.

## NextGov Hackathon

This app was started during the [Nextgov hackathon](https://eventornado.com/submission/automatic-sso-saml-sync-from-identity-provider-keycloak-through-a-well-known-protocol-scim?s=1#idea)!
