<?php

namespace OCA\SCIMServiceProvider\Responses;

use Exception;

/**
 * Class SCIMErrorResponse
 *
 */
class SCIMErrorResponse extends SCIMJSONResponse {

	public function __construct(Exception $e) {
		$data = [
			'schemas' => ['urn:ietf:params:scim:api:messages:2.0:Error'],
			'detail' => $e->getMessage(),
			'scimType' => '',
			'status' => $e->getCode(),
		];
		parent::__construct($data, $e->getCode());
	}
}
