<?php

namespace OCA\SCIMServiceProvider\Responses;

/**
 * Class SCIMListResponse
 *
 */
class SCIMListResponse extends SCIMJSONResponse {
	/**
	 * constructor of SCIMListResponse
	 * @param array $items array that should be transformed
	 * @since 6.0.0
	 */
	public function __construct(array $items = [], int $startIndex = 1, int $total = null) {
		if ($total === null) {
			$total = sizeof($items);
		}
		$data = [
			'schemas' => ['urn:ietf:params:scim:api:messages:2.0:ListResponse'],
			'startIndex' => $startIndex,
			'itemsPerPage' => sizeof($items),
			'totalResults' => $total,
			'Resources' => $items,
		];
		parent::__construct($data);
	}
}
