<?php
/**
 * @copyright Copyright (c) 2016 Roeland Jago Douma <roeland@famdouma.nl>
 *
 * @author Christoph Wurst <christoph@winzerhof-wurst.at>
 * @author Roeland Jago Douma <roeland@famdouma.nl>
 *
 * @license GNU AGPL version 3 or any later version
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */
namespace OCA\SCIMServiceProvider\Exceptions;

use Exception;

/**
 * Class SCIMException
 *
 * @since 9.1.0
 */
class SCIMException extends Exception {
    public function __construct(string $detail,
                                int $status = 500,
                                string $scimType='') {
        $message = [
            "schemas" => ["urn:ietf:params:scim:api:messages:2.0:Error"],
            "detail" => $detail,
            "scimType" => $scimType,
            "status" => $status
        ];

        parent::__construct(json_encode($message), $status);
    }

}